*Download files from the Health Inequality Data Repository (HIDR)

//	Get dataset ID reference list
	import delimited "https://srhdpeuwpubsa.blob.core.windows.net/whdh/HIDR/hidr_datasetid.csv", varnames(1) encoding("utf-8") clear

//	API base path
	global base ="https://datasafe-h5afbhf4gwctabaa.z01.azurefd.net/api"

// 	Specify the function to be used in the API (either "Download" or "Files")
	global function = "/Download" 
	
// 	Specify the Level 1 folder “TOP” containing all files
	global folder1 = "/TOP" 

// 	Download data file only for a given dataset ID (e.g., rep_rmnch)
	local url  = "$base$function$folder1/rep_rmnch/data"
	import excel "`url'", firstrow clear

//	Download ZIP file containing both the data and metadata files for a given dataset ID (e.g., rep_rmnch)
	*Note: file will be downloaded to the current working directory
	local url  = "$base$function$folder1/rep_rmnch"
	copy "`url'" "rep_rmnch.zip"

// 	Download all the latest datasets in the HIDR

	//	Get dataset ID reference list
		import delimited "https://srhdpeuwpubsa.blob.core.windows.net/whdh/HIDR/hidr_datasetid.csv", varnames(1) encoding("utf-8") clear
		levelsof dataset_id, local(datakey)

	//	Save data files as temporary files
		foreach id of local datakey {
			tempfile `id'
			import excel "$base$function$folder1/`id'/data", firstrow clear
			save "``id''", clear
		}

	// open a data file using the dataset ID (e.g., rep_rmnch)
		use `rep_rmnch', clear
		