# Download Files from API

## Attach library
  library(readxl)
  library(httr)

## Get dataset ID reference list
  id.key<-read.csv("https://srhdpeuwpubsa.blob.core.windows.net/whdh/HIDR/hidr_datasetid.csv")

## API base path
  base.path <-"https://datasafe-h5afbhf4gwctabaa.z01.azurefd.net/api"

## Specify the function to be used in the API (either "Download" or "Files")
  function.api <-"Download"

### Download data file only for a given dataset ID (e.g., rep_rmnch)
      url <-paste(base.path, function.api, "TOP", id.key$dataset_id[50], "data", sep = "/")
      GET(url, write_disk(tmp <- tempfile(fileext = ".xlsx")))
      data <-read_xlsx(tmp)

### Download ZIP file containing both the data and metadata files for a given dataset ID (e.g., rep_rmnch)
  url<-file.path(base.path, function.api, "TOP",  id.key$dataset_id[50])
  GET(url, write_disk(tmp <- tempfile(fileext = ".zip")))

  #### Create a local folder and extract the files (data and metadata) from the ZIP file
    dir.create(id.key$dataset_id[50])
    outdir<-id.key$dataset_id[50]
    unzip(tmp, exdir = outdir)

### Download all the latest datasets in the HIDR (It might take few minutes)
  list.data<-NULL
  for (i in id.key$dataset_id){
    url <-paste(base.path, function.api, "TOP", 
                i, "data", sep = "/")
    GET(url, write_disk(tmp <- tempfile(fileext = ".xlsx")))
    list.data[[i]]<-read_xlsx(tmp)
  }
  head(list.data[[id.key$dataset_id[50]]])